// terrain bump.vsh

uniform mat4 vc4;	// modelViewProj
uniform vec3 vc2;	// sun direction
uniform vec3 vc12;	// sun position

varying vec3 TangentSpaceSunDir;
varying vec3 TangentSpaceHalfVec;

void main()
{
	// Transform position
	gl_Position = gl_Vertex * vc4;
	
	// Compute tangent from normal based on the regularity of the heightfield.
	vec3 tangent = gl_Normal.xzy * vec3(0.0, 1.0, -1.0);

	// cross prod to generate binormal in model space -- "w"
	vec3 temp = gl_Normal.zxy * tangent.yzx;
	vec3 binormal = (gl_Normal.yzx * -tangent.zxy) - temp;

	// transform the light vector by the resulting matrix to get the light dir in tan space (into r6)
	TangentSpaceSunDir.x = dot( binormal, vc2 );
	TangentSpaceSunDir.y = dot( tangent, vc2 );
	TangentSpaceSunDir.z = dot( gl_Normal, vc2 );

	// multiply by a half then add half (to be scaled biased back inside pixel shader)
	//???
	
	// Get model space direction to camera.
	vec3 modelSpaceDirToCamera = normalize(vc12 - gl_Position.xyz);
	vec3 halfAngleVector = vc2 + modelSpaceDirToCamera;

	// Move H vector into tangent space.
	vec3 tangentSpaceH;
	tangentSpaceH.x = dot( binormal, halfAngleVector );
	tangentSpaceH.y = dot( tangent, halfAngleVector );
	tangentSpaceH.z = dot( gl_Normal, halfAngleVector );
   
	TangentSpaceHalfVec = normalize(tangentSpaceH);
	// multiply by a half then add half (to be scaled biased back inside pixel shader)
	//???
	
	// Set tex coords.  Diffuse, bump, mask share same coords.
    gl_TexCoord[0].st = gl_MultiTexCoord0.st;
}

/*
vs.1.1

dcl_position v0;
dcl_normal v1;
dcl_texcoord0 v2;

def c20, 0.5, 0.5, 0.5, 0.5
def c21, 0, 1, -1, 0

def c22, 0, 1, 0, 0    // hemisphere axis (up vector)
def c23, 2, 2, 2, 2


//compute position
m4x4 oPos, v0, c4

// Compute tangent from normal based on the regularity of the heightfield.
// -- just cross product with 1,0,0,0
mul r7, v1.xzy, c21

// cross prod to generate binormal in model space -- "w"
mul r0, v1.zxy, r7.yzx
mad r5, v1.yzx, -r7.zxy, -r0

// transform the light vector by the resulting matrix to get the light dir in tan space (into r6)
dp3 r6.x, r5, c2
dp3 r6.y, r7, c2
dp3 r6.z, v1, c2
mov r6.w, c22.x

// multiply by a half then add half (to be scaled biased back inside pixel shader)
mad oD1, r6, c20, c20

// Get model space direction to camera.
add r0, c12, -v0

// Normalize it.
dp3 r1.x, r0.xyz, r0.xyz
rsq r1.x, r1.x
mul r0.xyz, r0.xyz, r1.xxx

// Get "half-angle" vector.
add r0, r0, c2

// transform the H vector into tangent space
dp3 r1.x, r5, r0
dp3 r1.y, r7, r0
dp3 r1.z, v1, r0

dp3 r2.x, r1.xyz, r1.xyz
rsq r2.x, r2.x
mul r1.xyz, r1.xyz, r2.xxx

// multiply by a half then add half (to be scaled biased back inside pixel shader)
mad oD0.xyz, r1.xyz, c20, c20

// Copy texture coordinate to stages 0, 1, 2 (diffuse/bump/mask have same texcoords)
mov oT0, v2
mov oT1, v2
mov oT2, v2

*/